﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/connect/Connect_EXPORTS.h>
#include <aws/connect/model/VocabularySummary.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Connect {
namespace Model {
class SearchVocabulariesResult {
 public:
  AWS_CONNECT_API SearchVocabulariesResult() = default;
  AWS_CONNECT_API SearchVocabulariesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_CONNECT_API SearchVocabulariesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The list of the available custom vocabularies.</p>
   */
  inline const Aws::Vector<VocabularySummary>& GetVocabularySummaryList() const { return m_vocabularySummaryList; }
  template <typename VocabularySummaryListT = Aws::Vector<VocabularySummary>>
  void SetVocabularySummaryList(VocabularySummaryListT&& value) {
    m_vocabularySummaryListHasBeenSet = true;
    m_vocabularySummaryList = std::forward<VocabularySummaryListT>(value);
  }
  template <typename VocabularySummaryListT = Aws::Vector<VocabularySummary>>
  SearchVocabulariesResult& WithVocabularySummaryList(VocabularySummaryListT&& value) {
    SetVocabularySummaryList(std::forward<VocabularySummaryListT>(value));
    return *this;
  }
  template <typename VocabularySummaryListT = VocabularySummary>
  SearchVocabulariesResult& AddVocabularySummaryList(VocabularySummaryListT&& value) {
    m_vocabularySummaryListHasBeenSet = true;
    m_vocabularySummaryList.emplace_back(std::forward<VocabularySummaryListT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>If there are additional results, this is the token for the next set of
   * results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  SearchVocabulariesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  SearchVocabulariesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<VocabularySummary> m_vocabularySummaryList;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_vocabularySummaryListHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Connect
}  // namespace Aws
