﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/iot/IoT_EXPORTS.h>
#include <aws/iot/model/GroupNameAndArn.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace IoT {
namespace Model {
class ListThingGroupsResult {
 public:
  AWS_IOT_API ListThingGroupsResult() = default;
  AWS_IOT_API ListThingGroupsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_IOT_API ListThingGroupsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The thing groups.</p>
   */
  inline const Aws::Vector<GroupNameAndArn>& GetThingGroups() const { return m_thingGroups; }
  template <typename ThingGroupsT = Aws::Vector<GroupNameAndArn>>
  void SetThingGroups(ThingGroupsT&& value) {
    m_thingGroupsHasBeenSet = true;
    m_thingGroups = std::forward<ThingGroupsT>(value);
  }
  template <typename ThingGroupsT = Aws::Vector<GroupNameAndArn>>
  ListThingGroupsResult& WithThingGroups(ThingGroupsT&& value) {
    SetThingGroups(std::forward<ThingGroupsT>(value));
    return *this;
  }
  template <typename ThingGroupsT = GroupNameAndArn>
  ListThingGroupsResult& AddThingGroups(ThingGroupsT&& value) {
    m_thingGroupsHasBeenSet = true;
    m_thingGroups.emplace_back(std::forward<ThingGroupsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The token to use to get the next set of results. Will not be returned if
   * operation has returned all results.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListThingGroupsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListThingGroupsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<GroupNameAndArn> m_thingGroups;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_thingGroupsHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace IoT
}  // namespace Aws
