﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/globalaccelerator/GlobalAcceleratorRequest.h>
#include <aws/globalaccelerator/GlobalAccelerator_EXPORTS.h>

#include <utility>

namespace Aws {
namespace GlobalAccelerator {
namespace Model {

/**
 */
class DescribeCrossAccountAttachmentRequest : public GlobalAcceleratorRequest {
 public:
  AWS_GLOBALACCELERATOR_API DescribeCrossAccountAttachmentRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "DescribeCrossAccountAttachment"; }

  AWS_GLOBALACCELERATOR_API Aws::String SerializePayload() const override;

  AWS_GLOBALACCELERATOR_API Aws::Http::HeaderValueCollection GetRequestSpecificHeaders() const override;

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) for the cross-account attachment to
   * describe.</p>
   */
  inline const Aws::String& GetAttachmentArn() const { return m_attachmentArn; }
  inline bool AttachmentArnHasBeenSet() const { return m_attachmentArnHasBeenSet; }
  template <typename AttachmentArnT = Aws::String>
  void SetAttachmentArn(AttachmentArnT&& value) {
    m_attachmentArnHasBeenSet = true;
    m_attachmentArn = std::forward<AttachmentArnT>(value);
  }
  template <typename AttachmentArnT = Aws::String>
  DescribeCrossAccountAttachmentRequest& WithAttachmentArn(AttachmentArnT&& value) {
    SetAttachmentArn(std::forward<AttachmentArnT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_attachmentArn;
  bool m_attachmentArnHasBeenSet = false;
};

}  // namespace Model
}  // namespace GlobalAccelerator
}  // namespace Aws
